function AISMN_PickupItem::OnEnter(%this,%obj)
{
   //Get our target
   %prop = GetParameterTarget(%obj);
   if(0 == %prop)
   {
      SetStateVariable(%obj,0,1);
      return;
   }
   %cmpProp = slgQueryInterface(%prop, $CID_PROP);
   if (isObject(%cmpProp) == false)
   {
      SetStateVariable(%obj,0,1);
      return;
   }
   
   // if the object that is selected to carry-out the prop command
   // is not a character, exit.
   %cmpCharacter = slgQueryInterface(GetThisObject(%obj), $CID_CHARACTER);
   if (isObject(%cmpCharacter) == false)
   {
      SetStateVariable(%obj,0,1);
      return;
   }
   if (%cmpCharacter.inState($CharacterState::Drunk))
   {
      SetStateVariable(%obj,0,1);
      return;
   }
   %gender = %cmpCharacter.getDatablock();
   %gender = %gender.gender;
   
   //Get the work items.
   %index = 0;
   %item = %cmpProp.getWorkItem(%index,%gender);
   while(strlen(%item)>0)
   {
      %mountIndex = %cmpProp.getWorkItemMount(%index,%gender);
      if (%mountIndex != 0 || $HatEnabled == true)
      {
         GetThisObject(%obj).mountImage(%item,%mountIndex);
      }
      %index++; 
      %item = %cmpProp.getWorkItem(%index,%gender);
   }
      
   // start collecting on the target prop   
   %cmpCharacter.startCollecting(%prop);
   %prop.playThread(0, "pickup");
   %ani = %cmpProp.getWorkAnimation();
   GetThisObject(%obj).playThread( 0, %ani);
   
   if(%cmpProp.isPickUpProp())
   {
      if(isObject(MsgSender))
         MsgSender.sendMsg($MSG_SLGOBJPICKUP, $MRT_LOCAL, %prop, GetThisObject(%obj));
      
      if(%cmpProp.poolWood > 0)
         playSFXSound(pickup_wood);
      else if(%cmpProp.poolFood > 0)
         playSFXSound(pickup_food);
      else if(%cmpProp.poolGold > 0)
         playSFXSound(pickup_gold);
      else
         playSFXSound(pickup_generic);
   }
   else if(%cmpProp.isJobProp())
   {
      if(isObject(MsgSender))
         MsgSender.sendMsg($MSG_SLGOBJQUICKJOB, $MRT_LOCAL, %prop, GetThisObject(%obj));
      
      if(%cmpProp.poolWood > 0)
         playSFXSound(quickjob_wood);
      else if(%cmpProp.poolFood > 0)
         playSFXSound(quickjob_food);
      else if(%cmpProp.poolGold > 0)
         playSFXSound(quickjob_gold);
   }
   
   //Face the prop
   FaceObject(%obj,%prop);
}

function AISMN_PickupItem::OnExit(%this,%obj)
{
   //GetThisObject(%obj).playThread( 0, "root");
   // if the object that is selected to carry-out the prop command
   // is not a character, exit.
   %cmpCharacter = slgQueryInterface(GetThisObject(%obj), $CID_CHARACTER);
   if (isObject(%cmpCharacter) == false)
   {
      SetStateVariable(%obj,0,1);
      return;
   }
   %cmpCharacter.stopCollecting();
   RestoreCharacterOutfit(%obj);
   
   // stop animating when pick up item is done
   GetThisObject(%obj).playThread(0, "root");
   return;
}

function AISMN_PickupItem::Update(%this,%obj)
{   
   //Was there a parameter issue that prevents us from picking up the object? Leave.
   if(GetStateVariable(%obj,0) > 0)
   {
      ReturnValue(%obj, 1);
      return;
   }
   
   //If we're done collecting, exit the state
   %cmpCharacter = slgQueryInterface(GetThisObject(%obj), $CID_CHARACTER);
   if (isObject(%cmpCharacter) == false)
   {
      ReturnValue(%obj, 1);
      return;
   }
   if (%cmpCharacter.isCollecting() == false && TimeInNode(%obj) >= 2.5)
   {
      ReturnValue(%obj,0);
      return;
   }

   //Continue along our merry way.
   ReturnValue(%obj,-1);
   return;
}